within ModelicaLib.Driveshaft_test;
model DriveshaftTestBench

  Driveshaft driveshaft
    annotation (Placement(transformation(extent={{-10,24},{10,44}})));
  Modelica.Blocks.Sources.Ramp ramp(height=100, duration=20)
    annotation (Placement(transformation(extent={{-90,30},{-70,50}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-46,28},{-26,48}})));
  Modelica.Mechanics.Rotational.Components.Damper damper1(d=0.5)
    annotation (Placement(transformation(extent={{44,28},{64,48}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{56,-6},{76,14}})));
equation
  connect(torque.flange, driveshaft.flange_a) annotation (Line(
      points={{-26,38},{-16.8,38},{-16.8,38.6},{-7.6,38.6}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(ramp.y, torque.tau) annotation (Line(
      points={{-69,40},{-58,40},{-58,38},{-48,38}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(damper1.flange_b,fixed. flange) annotation (Line(
      points={{64,38},{66,38},{66,4}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(driveshaft.flange_b, damper1.flange_a) annotation (Line(
      points={{7,38.6},{25.5,38.6},{25.5,38},{44,38}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end DriveshaftTestBench;
